%Galerkinova metoda tezinskog ostatka
%Konzola - jednako podeljeno opterecenje
%*****************************************************************
clear;clc;
%Tacno resenje diferencijalne jednacine savijanja
syms Em Iy L qz UgibTacno(x) Mtacno(x) Ttacno(x)...
     f1(x) f2(x) UgibPribliznoOpste(x) I1(a1,a2) I2(a1,a2)...
     UgibPriblizno(x) Mpriblizno(x) Tpriblizno(x);
UgibTacno(x)=dsolve('Em*Iy*D4y=qz','y(0)=0','Dy(0)=0','Em*Iy*D2y(L)=0','Em*Iy*D3y(L)=0','x');
Mtacno(x)=diff(-Em*Iy*UgibTacno(x),x,2);
Ttacno(x)=diff(Mtacno(x),x,1);
%Priblizno resenje
f1(x)=x^2;
f2(x)=x^3;
UgibPribliznoOpste(x)=a1*f1(x)+a2*f2(x);
I1(a1,a2)=int(Em*Iy*diff(UgibPribliznoOpste(x),x,2)*diff(f1(x),x,2)-qz*f1(x),x,[0,L]);
I2(a1,a2)=int(Em*Iy*diff(UgibPribliznoOpste(x),x,2)*diff(f2(x),x,2)-qz*f2(x),x,[0,L]);
sol=solve([I1(a1,a2)==0,I2(a1,a2)==0],[a1,a2]);
UgibPriblizno(x)=sol.a1*f1(x)+sol.a2*f2(x);
Mpriblizno(x)=diff(-Em*Iy*UgibPriblizno(x),x,2);
Tpriblizno(x)=diff(Mpriblizno(x),x,1);
%*****************************************************************
fprintf('za i=1-> %s %s\n',I1(a1,a2),' = 0');
fprintf('za i=2-> %s %s\n',I2(a1,a2),' = 0');
fprintf('a1 = %s\n',simplify(sol.a1));
fprintf('a2 = %s\n',simplify(sol.a2));
%*****************************************************************
%Pojedinacni grafici
%Tacna resenja
figure('Name','w(x) - Tacno');
hold on;
set(gca,'Ydir','reverse');
grid on;
naslov=strcat('w(x)=[qz*L^4/(24EIy)]*[',sprintf('%s',expand(UgibTacno(x)/((qz*L^4)/(24*Em*Iy)))),']');
title(naslov);
fplot(subs(UgibTacno(x),{Em,Iy,L,qz},{1,1,1,1}),[0,1],'Linewidth',2,'Color','black');
hold off;
figure('Name','M(x) - Tacno');
hold on;
set(gca,'Ydir','reverse');
grid on;
naslov=strcat('M(x)=[qz*L^2)/12]*[',sprintf('%s',expand(Mtacno(x)/((qz*L^2)/12))),']');
title(naslov);
fplot(subs(Mtacno(x),{Em,Iy,L,qz},{1,1,1,1}),[0,1],'Linewidth',2,'Color','black');
hold off;
figure('Name','T(x) - Tacno');
hold on;
set(gca,'Ydir','reverse');
grid on;
naslov=strcat('T(x)=[qz]*[',sprintf('%s',expand(Ttacno(x)/qz)),']');
title(naslov);
fplot(subs(Ttacno(x),{Em,Iy,L,qz},{1,1,1,1}),[0,1],'Linewidth',2,'Color','black');
hold off;
%Priblizna resenja
figure('Name','w(x) - Priblizno');
hold on;
set(gca,'Ydir','reverse');
grid on;
naslov=strcat('w(x)=[qz*L^4/(24EIy)]*[',sprintf('%s',expand(UgibPriblizno(x)/((qz*L^4)/(24*Em*Iy)))),']');
title(naslov);
fplot(subs(UgibPriblizno(x),{Em,Iy,L,qz},{1,1,1,1}),[0,1],'Linewidth',2,'Color','black');
hold off;
figure('Name','M(x) - Priblizno');
hold on;
set(gca,'Ydir','reverse');
grid on;
naslov=strcat('M(x)=[qz*L^2)/12]*[',sprintf('%s',expand(Mpriblizno(x)/((qz*L^2)/12))),']');
title(naslov);
fplot(subs(Mpriblizno(x),{Em,Iy,L,qz},{1,1,1,1}),[0,1],'Linewidth',2,'Color','black');
hold off;
figure('Name','T(x) - Priblizno');
hold on;
set(gca,'Ydir','reverse');
grid on;
naslov=strcat('T(x)=[qz]*[',sprintf('%s',expand(Tpriblizno(x)/qz)),']');
title(naslov);
fplot(subs(Tpriblizno(x),{Em,Iy,L,qz},{1,1,1,1}),[0,1],'Linewidth',2,'Color','black');
hold off;
%Jedan prozor sa vise grafika
figure('Name','Grafici');
subplot(2,3,1);
fplot(subs(UgibTacno(x),{Em,Iy,L,qz},{1,1,1,1}),[0,1],'Linewidth',2,'Color','black');
set(gca,'Ydir','reverse');
grid on
naslov=strcat('w(x)=[qz*L^4/(24EIy)]*[',sprintf('%s',expand(UgibTacno(x)/((qz*L^4)/(24*Em*Iy)))),']');
title(naslov);
subplot(2,3,2);
fplot(subs(Mtacno(x),{Em,Iy,L,qz},{1,1,1,1}),[0,1],'Linewidth',2,'Color','black');
set(gca,'Ydir','reverse');
grid on
naslov=strcat('M(x)=[qz*L^2)/12]*[',sprintf('%s',expand(Mtacno(x)/((qz*L^2)/12))),']');
title(naslov);
subplot(2,3,3);
fplot(subs(Ttacno,{Em,Iy,L,qz},{1,1,1,1}),[0,1],'Linewidth',2,'Color','black');
set(gca,'Ydir','reverse');
grid on
naslov=strcat('T(x)=[qz]*[',sprintf('%s',expand(Ttacno(x)/qz)),']');
title(naslov);
subplot(2,3,4);
fplot(subs(UgibPriblizno(x),{Em,Iy,L,qz},{1,1,1,1}),[0,1],'Linewidth',2,'Color','black');
set(gca,'Ydir','reverse');
grid on
naslov=strcat('w(x)=[qz*L^4/(24EIy)]*[',sprintf('%s',expand(UgibPriblizno(x)/((qz*L^4)/(24*Em*Iy)))),']');
title(naslov);
subplot(2,3,5);
fplot(subs(Mpriblizno(x),{Em,Iy,L,qz},{1,1,1,1}),[0,1],'Linewidth',2,'Color','black');
set(gca,'Ydir','reverse');
grid on
naslov=strcat('M(x)=[qz*L^2)/12]*[',sprintf('%s',expand(Mpriblizno(x)/((qz*L^2)/12))),']');
title(naslov);
subplot(2,3,6);
fplot(subs(Tpriblizno(x),{Em,Iy,L,qz},{1,1,1,1}),[0,1],'Linewidth',2,'Color','black');
set(gca,'Ydir','reverse');
grid on
naslov=strcat('T(x)=[qz]*[',sprintf('%s',expand(Tpriblizno(x)/qz)),']');
title(naslov);
%*****************************************************************
clear;